/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.fcs.impl;

import com.ibm.hwmca.base.managed.BaseTower;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.connmgr.Connection;
import com.ibm.hwmca.fw.connmgr.ConnectionFactory;
import com.ibm.hwmca.fw.connmgr.ConnectionGroup;
import com.ibm.hwmca.fw.fcs.FcsConnection;
import com.ibm.hwmca.fw.fcs.FcsServer;
import com.ibm.hwmca.fw.fcs.FcsServiceId;
import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.fcs.impl.stream.FcsControlClient;
import com.ibm.hwmca.fw.system.CommonSystem;
import com.ibm.hwmca.fw.util.Trace;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class FcsConnectionManager
extends Thread {
    private static final String TRACE_MASKD = "XFCSFCMD";
    private static final String TRACE_MASKF = "XFCSFCMF";
    private static final String TRACE_MASKT = "XFCSFCMT";
    private static List openConnections = new ArrayList();
    private static Object openConnectionsLock = new Object();
    private boolean _doWork = true;
    private Object doWorkLock = new Object();
    private static final int DEFAULT_SLEEP_TIME = 300000;
    private static int sleepTime = 300000;
    private static final String BAD_CONNECTION_ADDRESS = "0.0.0.0";
    private static Map factories = new HashMap();
    private static Set whiteListedMachines = new HashSet();
    private static Map handshakedMachines = new HashMap();

    public FcsConnectionManager() {
        super("FCS - Connection Manager Thread");
    }

    public static void addWhiteListedMachine(InetAddress iaddr) {
        whiteListedMachines.add(iaddr);
    }

    public static void removeWhiteListedMachine(InetAddress iaddr) {
        whiteListedMachines.remove(iaddr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FcsConnection getConnection(int id) {
        Object object = openConnectionsLock;
        synchronized (object) {
            Iterator iterator = openConnections.iterator();
            while (iterator.hasNext()) {
                FcsConnection c = (FcsConnection)iterator.next();
                if (c.getConnectionId() != id) continue;
                return c;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addConnection(FcsConnection connection) {
        Object object = openConnectionsLock;
        synchronized (object) {
            openConnections.add(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean doWork = true;
        while (doWork) {
            Set machines = FcsServer.getFcsServer().getMachineList();
            FcsServiceId controlId = new FcsServiceId("com.ibm.hwmca.fw.fcs.impl.stream.FcsControlServiceToken", 1.0);
            FcsServer.getFcsServer().dump();
            Iterator iterator = machines.iterator();
            while (iterator.hasNext()) {
                MachineId nextId = (MachineId)iterator.next();
                if (!nextId.equals(FcsServer.getFcsServer().getLocalMachineId())) {
                    Object o = handshakedMachines.get(nextId);
                    if (o == null || System.currentTimeMillis() - (Long)o > (long)sleepTime) {
                        if (o == null) {
                            Trace.trace(TRACE_MASKF, "handshaking, stored value is null");
                        } else {
                            Trace.trace(TRACE_MASKF, "Handshaking, Stored value: " + (Long)o + ", current time: " + System.currentTimeMillis() + ", difference= " + (System.currentTimeMillis() - (Long)o) + ", sleep time: " + sleepTime + ", " + nextId);
                        }
                        FcsControlClient fcc = new FcsControlClient(nextId, "FcsControlCommandDataExchange");
                        fcc.run();
                        handshakedMachines.put(nextId, new Long(System.currentTimeMillis()));
                    } else if (o == null) {
                        Trace.trace(TRACE_MASKF, "Not handshaking, stored value is null");
                    } else {
                        Trace.trace(TRACE_MASKF, "Not handshaking, Stored value: " + (Long)o + ", current time: " + System.currentTimeMillis() + ", difference= " + (System.currentTimeMillis() - (Long)o) + ", sleep time: " + sleepTime + ", " + nextId);
                    }
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
            Object object = openConnectionsLock;
            synchronized (object) {
                ListIterator iterator2 = openConnections.listIterator();
                while (iterator2.hasNext()) {
                    FcsConnection c = (FcsConnection)iterator2.next();
                    if (c == null) {
                        iterator2.remove();
                        continue;
                    }
                    if (c.getSocket() == null) {
                        iterator2.remove();
                        continue;
                    }
                    if (c.getSocket().getInetAddress() == null) {
                        try {
                            c.getSocket().close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        iterator2.remove();
                        continue;
                    }
                    InetAddress remoteHost = c.getSocket().getInetAddress();
                    InetAddress localHost = c.getSocket().getLocalAddress();
                    if (!localHost.getHostAddress().equals(BAD_CONNECTION_ADDRESS) && !remoteHost.getHostAddress().equals(BAD_CONNECTION_ADDRESS)) continue;
                    try {
                        c.getSocket().close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    iterator2.remove();
                }
            }
            Set tmp = (Set)((HashSet)whiteListedMachines).clone();
            Iterator iterator3 = tmp.iterator();
            while (iterator3.hasNext()) {
                InetAddress iaddr = (InetAddress)iterator3.next();
                if (FcsServer.getFcsServer().getMachineId(iaddr) != null) continue;
                FcsControlClient fcc = new FcsControlClient(iaddr, "FcsControlCommandDataExchange");
                fcc.run();
            }
            FcsControlClient.updateBlacklist();
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            Object object2 = this.doWorkLock;
            synchronized (object2) {
                doWork = this._doWork;
            }
        }
    }

    public static void didHandshake(MachineId handshakedMachine) {
        Trace.trace(TRACE_MASKF, "did handshake with: " + handshakedMachine + " at " + System.currentTimeMillis());
        handshakedMachines.put(handshakedMachine, new Long(System.currentTimeMillis()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopWork() {
        Object object = this.doWorkLock;
        synchronized (object) {
            this._doWork = false;
            factories.clear();
        }
    }

    public static void setMachineListPingTime(int seconds) {
        sleepTime = seconds <= 0 ? 300000 : seconds * 1000;
    }

    public static Connection connect(InetAddress iaddr, Serializable parm) {
        ConnectionFactory factory = (ConnectionFactory)factories.get(iaddr);
        if (factory == null) {
            factory = new ConnectionFactory(iaddr, 9920);
            try {
                factory.setUserAndPassword(FcsConnectionManager.getHMCUserId(), FcsConnectionManager.getHMCPassword());
            }
            catch (Exception e) {
                factory = null;
            }
            if (factory != null) {
                factories.put(iaddr, factory);
            } else {
                return null;
            }
        }
        try {
            ConnectionGroup group = factory.getConnections("fcs", 1, parm);
            return group.getConnections()[0];
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeConnectionInformation(InetAddress iaddr) {
        Object object = openConnectionsLock;
        synchronized (object) {
            ListIterator iterator = openConnections.listIterator();
            while (iterator.hasNext()) {
                FcsConnection c = (FcsConnection)iterator.next();
                InetAddress[] iaddrs = c.getMachineId().getNicAddresses();
                boolean doRemove = false;
                int i = 0;
                while (i < iaddrs.length) {
                    if (iaddrs[i] != null && iaddrs[i].equals(iaddr)) {
                        try {
                            c.getSocket().close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        doRemove = true;
                    }
                    ++i;
                }
                if (!doRemove) continue;
                iterator.remove();
            }
        }
        factories.remove(iaddr);
    }

    private static String getHMCUserId() {
        String user;
        try {
            user = BaseTower.getBaseTower().getDomainName();
        }
        catch (HException he) {
            user = "";
        }
        if (user == null || user.trim().equals("")) {
            user = "FOO";
        }
        return user;
    }

    private static byte[] getHMCPassword() {
        byte[] password;
        try {
            password = BaseTower.getBaseTower().getDomainPassword();
        }
        catch (HException he) {
            password = null;
        }
        if (password == null || password.length == 0) {
            password = CommonSystem.getCommonSystem().hashPassword("BAR");
        }
        return password;
    }

    public void domainNameChanged() {
        factories.clear();
    }
}

